#ifndef MEETINGFEATURESET_H
#define MEETINGFEATURESET_H

#include "csfunified/featuresets/adapters/FeatureSetAdapter.h"
#include "csfunified/framework/UnifiedFactory.h"
#include "featuresets/MeetingFeatureSet.h"
#include "services/impl/desktopshare/DesktopSharingControllerImplMac.h"
#include "services/impl/desktopshare/DesktopSharingControllerImplWin.h"
#include "services/impl/cmr/CMRControllerImpl.h"
#include "services/impl/meetingmgr/MeetingMgrControllerImplMac.h"
#include "services/impl/meetingmgr/MeetingMgrControllerImplWin.h"
#include "services/impl/account/MeetingAccountControllerImpl.h"
#include "services/impl/cmr/CMRControllerMgr.h"
#include <csf/RWLock.hpp>

namespace CSFUnified
{
    class CMRMeetingCallback;
	class InstantMeetingController;
    class MeetingMgrController;
    class DesktopSharingController;
    class MeetingAccountController;
    class CMRController;
    
	class CSFUNIFIED_API MeetingFeatureSetAdapter : public FeatureSetAdapter, public MeetingFeatureSet
	{

	public:
		MeetingFeatureSetAdapter(SMART_PTR_NS::shared_ptr<UnifiedFactory> unifiedFactory);
        ~MeetingFeatureSetAdapter();

		// FeatureSetAdapter methods
		void StartFeatureSet(unsigned int type, ServiceEventVtrPtr errors);
		void StopFeatureSet(unsigned int type, ServiceEventVtrPtr errors);
		void Destroy();

		std::vector<unsigned int> GetFeatureSetDependencies(unsigned int type);
		bool IsFeatureSetStarted(unsigned int type);
		bool IsFeatureSetProvisioned(unsigned int type);
		void start();
		void stop();

        virtual SMART_PTR_NS::shared_ptr<CSFUnified::MeetingMgrController> getMeetingMgrController();
        virtual SMART_PTR_NS::shared_ptr<CSFUnified::DesktopSharingController> getDesktopSharingController();
        virtual SMART_PTR_NS::shared_ptr<CSFUnified::MeetingAccountController> getMeetingAccountController();
        virtual SMART_PTR_NS::shared_ptr<CSFUnified::CMRController> getCMRController(std::string JID);
        virtual void registerCMRMeetingCallback(SMART_PTR_NS::shared_ptr<CSFUnified::CMRMeetingCallback> callback);
        virtual void unregisterCMRMeetingCallback(SMART_PTR_NS::shared_ptr<CSFUnified::CMRMeetingCallback> callback);
        
    private:
		bool m_started;
		csf::RWLock mLock;
		SMART_PTR_NS::shared_ptr<UnifiedFactory> unifiedFactory;
        
        SMART_PTR_NS::shared_ptr<DesktopSharingControllerImpl> m_pDSController;
        SMART_PTR_NS::shared_ptr<MeetingMgrControllerImpl> m_pMeetingMgrController;
        SMART_PTR_NS::shared_ptr<MeetingAccountControllerImpl> m_pMeetingAccountController;

        //refactor
        SMART_PTR_NS::shared_ptr<CMRControllerMgr> m_cmrMgr;
	};
}


#endif 

